/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.internal.r;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PolygonOptionsCreator;
import com.google.android.gms.maps.model.g;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PolygonOptions
implements SafeParcelable {
    public static final PolygonOptionsCreator CREATOR = new PolygonOptionsCreator();
    private final int iM;
    private final List<LatLng> qK;
    private final List<List<LatLng>> qL;
    private float qh = 10.0f;
    private int qi = -16777216;
    private int qj = 0;
    private float qk = 0.0f;
    private boolean ql = true;
    private boolean qM = false;

    public PolygonOptions() {
        this.iM = 1;
        this.qK = new ArrayList<LatLng>();
        this.qL = new ArrayList<List<LatLng>>();
    }

    PolygonOptions(int versionCode, List<LatLng> points, List holes, float strokeWidth, int strokeColor, int fillColor, float zIndex, boolean visible, boolean geodesic) {
        this.iM = versionCode;
        this.qK = points;
        this.qL = holes;
        this.qh = strokeWidth;
        this.qi = strokeColor;
        this.qj = fillColor;
        this.qk = zIndex;
        this.ql = visible;
        this.qM = geodesic;
    }

    int getVersionCode() {
        return this.iM;
    }

    List cO() {
        return this.qL;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (r.cK()) {
            g.a(this, out, flags);
        } else {
            PolygonOptionsCreator.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    public PolygonOptions add(LatLng point) {
        this.qK.add(point);
        return this;
    }

    public PolygonOptions add(LatLng ... points) {
        this.qK.addAll(Arrays.asList(points));
        return this;
    }

    public PolygonOptions addAll(Iterable<LatLng> points) {
        for (LatLng latLng : points) {
            this.qK.add(latLng);
        }
        return this;
    }

    public PolygonOptions addHole(Iterable<LatLng> points) {
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        for (LatLng latLng : points) {
            arrayList.add(latLng);
        }
        this.qL.add(arrayList);
        return this;
    }

    public PolygonOptions strokeWidth(float width) {
        this.qh = width;
        return this;
    }

    public PolygonOptions strokeColor(int color2) {
        this.qi = color2;
        return this;
    }

    public PolygonOptions fillColor(int color2) {
        this.qj = color2;
        return this;
    }

    public PolygonOptions zIndex(float zIndex) {
        this.qk = zIndex;
        return this;
    }

    public PolygonOptions visible(boolean visible) {
        this.ql = visible;
        return this;
    }

    public PolygonOptions geodesic(boolean geodesic) {
        this.qM = geodesic;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.qK;
    }

    public List<List<LatLng>> getHoles() {
        return this.qL;
    }

    public float getStrokeWidth() {
        return this.qh;
    }

    public int getStrokeColor() {
        return this.qi;
    }

    public int getFillColor() {
        return this.qj;
    }

    public float getZIndex() {
        return this.qk;
    }

    public boolean isVisible() {
        return this.ql;
    }

    public boolean isGeodesic() {
        return this.qM;
    }
}

