/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.GoogleMapOptionsCreator;
import com.google.android.gms.maps.a;
import com.google.android.gms.maps.internal.r;
import com.google.android.gms.maps.model.CameraPosition;

public final class GoogleMapOptions
implements SafeParcelable {
    public static final GoogleMapOptionsCreator CREATOR = new GoogleMapOptionsCreator();
    private final int iM;
    private Boolean px;
    private Boolean py;
    private int pz = -1;
    private CameraPosition pA;
    private Boolean pB;
    private Boolean pC;
    private Boolean pD;
    private Boolean pE;
    private Boolean pF;
    private Boolean pG;

    GoogleMapOptions(int versionCode, byte zOrderOnTop, byte useViewLifecycleInFragment, int mapType, CameraPosition camera, byte zoomControlsEnabled, byte compassEnabled, byte scrollGesturesEnabled, byte zoomGesturesEnabled, byte tiltGesturesEnabled, byte rotateGesturesEnabled) {
        this.iM = versionCode;
        this.px = com.google.android.gms.maps.internal.a.a(zOrderOnTop);
        this.py = com.google.android.gms.maps.internal.a.a(useViewLifecycleInFragment);
        this.pz = mapType;
        this.pA = camera;
        this.pB = com.google.android.gms.maps.internal.a.a(zoomControlsEnabled);
        this.pC = com.google.android.gms.maps.internal.a.a(compassEnabled);
        this.pD = com.google.android.gms.maps.internal.a.a(scrollGesturesEnabled);
        this.pE = com.google.android.gms.maps.internal.a.a(zoomGesturesEnabled);
        this.pF = com.google.android.gms.maps.internal.a.a(tiltGesturesEnabled);
        this.pG = com.google.android.gms.maps.internal.a.a(rotateGesturesEnabled);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (r.cK()) {
            a.a(this, out, flags);
        } else {
            GoogleMapOptionsCreator.a(this, out, flags);
        }
    }

    int getVersionCode() {
        return this.iM;
    }

    byte cv() {
        return com.google.android.gms.maps.internal.a.b(this.px);
    }

    byte cw() {
        return com.google.android.gms.maps.internal.a.b(this.py);
    }

    byte cx() {
        return com.google.android.gms.maps.internal.a.b(this.pB);
    }

    byte cy() {
        return com.google.android.gms.maps.internal.a.b(this.pC);
    }

    byte cz() {
        return com.google.android.gms.maps.internal.a.b(this.pD);
    }

    byte cA() {
        return com.google.android.gms.maps.internal.a.b(this.pE);
    }

    byte cB() {
        return com.google.android.gms.maps.internal.a.b(this.pF);
    }

    byte cC() {
        return com.google.android.gms.maps.internal.a.b(this.pG);
    }

    public GoogleMapOptions() {
        this.iM = 1;
    }

    public GoogleMapOptions zOrderOnTop(boolean zOrderOnTop) {
        this.px = zOrderOnTop;
        return this;
    }

    public GoogleMapOptions useViewLifecycleInFragment(boolean useViewLifecycleInFragment) {
        this.py = useViewLifecycleInFragment;
        return this;
    }

    public GoogleMapOptions mapType(int mapType) {
        this.pz = mapType;
        return this;
    }

    public GoogleMapOptions camera(CameraPosition camera) {
        this.pA = camera;
        return this;
    }

    public GoogleMapOptions zoomControlsEnabled(boolean enabled) {
        this.pB = enabled;
        return this;
    }

    public GoogleMapOptions compassEnabled(boolean enabled) {
        this.pC = enabled;
        return this;
    }

    public GoogleMapOptions scrollGesturesEnabled(boolean enabled) {
        this.pD = enabled;
        return this;
    }

    public GoogleMapOptions zoomGesturesEnabled(boolean enabled) {
        this.pE = enabled;
        return this;
    }

    public GoogleMapOptions tiltGesturesEnabled(boolean enabled) {
        this.pF = enabled;
        return this;
    }

    public GoogleMapOptions rotateGesturesEnabled(boolean enabled) {
        this.pG = enabled;
        return this;
    }

    public Boolean getZOrderOnTop() {
        return this.px;
    }

    public Boolean getUseViewLifecycleInFragment() {
        return this.py;
    }

    public int getMapType() {
        return this.pz;
    }

    public CameraPosition getCamera() {
        return this.pA;
    }

    public Boolean getZoomControlsEnabled() {
        return this.pB;
    }

    public Boolean getCompassEnabled() {
        return this.pC;
    }

    public Boolean getScrollGesturesEnabled() {
        return this.pD;
    }

    public Boolean getZoomGesturesEnabled() {
        return this.pE;
    }

    public Boolean getTiltGesturesEnabled() {
        return this.pF;
    }

    public Boolean getRotateGesturesEnabled() {
        return this.pG;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attrs, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(0)) {
            googleMapOptions.mapType(typedArray.getInt(0, -1));
        }
        if (typedArray.hasValue(13)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(13, false));
        }
        if (typedArray.hasValue(12)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(12, false));
        }
        if (typedArray.hasValue(6)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(6, true));
        }
        if (typedArray.hasValue(7)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(7, true));
        }
        if (typedArray.hasValue(8)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(8, true));
        }
        if (typedArray.hasValue(9)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(9, true));
        }
        if (typedArray.hasValue(11)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(11, true));
        }
        if (typedArray.hasValue(10)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(10, true));
        }
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attrs);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }
}

