/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.internal.dl;
import com.google.android.gms.internal.dm;
import com.google.android.gms.internal.en;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InvitationEntity
extends en
implements Invitation {
    public static final Parcelable.Creator<InvitationEntity> CREATOR = new a();
    private final int iM;
    private final GameEntity nL;
    private final String nM;
    private final long nN;
    private final int nO;
    private final ParticipantEntity nP;
    private final ArrayList<ParticipantEntity> nQ;
    private final int nR;

    InvitationEntity(Invitation invitation) {
        this.iM = 1;
        this.nL = new GameEntity(invitation.getGame());
        this.nM = invitation.getInvitationId();
        this.nN = invitation.getCreationTimestamp();
        this.nO = invitation.ch();
        this.nR = invitation.getVariant();
        String string2 = invitation.getInviter().getParticipantId();
        Participant participant = null;
        ArrayList arrayList = invitation.getParticipants();
        int n2 = arrayList.size();
        this.nQ = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant2 = (Participant)arrayList.get(i2);
            if (participant2.getParticipantId().equals(string2)) {
                participant = participant2;
            }
            this.nQ.add((ParticipantEntity)participant2.freeze());
        }
        dm.a(participant, (Object)"Must have a valid inviter!");
        this.nP = (ParticipantEntity)participant.freeze();
    }

    InvitationEntity(int versionCode, GameEntity game, String invitationId, long creationTimestamp, int invitationType, ParticipantEntity inviter, ArrayList<ParticipantEntity> participants, int variant) {
        this.iM = versionCode;
        this.nL = game;
        this.nM = invitationId;
        this.nN = creationTimestamp;
        this.nO = invitationType;
        this.nP = inviter;
        this.nQ = participants;
        this.nR = variant;
    }

    public int getVersionCode() {
        return this.iM;
    }

    @Override
    public Game getGame() {
        return this.nL;
    }

    @Override
    public String getInvitationId() {
        return this.nM;
    }

    @Override
    public Participant getInviter() {
        return this.nP;
    }

    @Override
    public long getCreationTimestamp() {
        return this.nN;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.nQ);
    }

    @Override
    public int ch() {
        return this.nO;
    }

    @Override
    public int getVariant() {
        return this.nR;
    }

    @Override
    public Invitation freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return InvitationEntity.a(this);
    }

    static int a(Invitation invitation) {
        return dl.hashCode(invitation.getGame(), invitation.getInvitationId(), invitation.getCreationTimestamp(), invitation.ch(), invitation.getInviter(), invitation.getParticipants(), invitation.getVariant());
    }

    public boolean equals(Object obj) {
        return InvitationEntity.a(this, obj);
    }

    static boolean a(Invitation invitation, Object object) {
        if (!(object instanceof Invitation)) {
            return false;
        }
        if (invitation == object) {
            return true;
        }
        Invitation invitation2 = (Invitation)object;
        return dl.equal(invitation2.getGame(), invitation.getGame()) && dl.equal(invitation2.getInvitationId(), invitation.getInvitationId()) && dl.equal(invitation2.getCreationTimestamp(), invitation.getCreationTimestamp()) && dl.equal(invitation2.ch(), invitation.ch()) && dl.equal(invitation2.getInviter(), invitation.getInviter()) && dl.equal(invitation2.getParticipants(), invitation.getParticipants()) && dl.equal(invitation2.getVariant(), invitation.getVariant());
    }

    public String toString() {
        return InvitationEntity.b(this);
    }

    static String b(Invitation invitation) {
        return dl.d(invitation).a("Game", invitation.getGame()).a("InvitationId", invitation.getInvitationId()).a("CreationTimestamp", invitation.getCreationTimestamp()).a("InvitationType", invitation.ch()).a("Inviter", invitation.getInviter()).a("Participants", invitation.getParticipants()).a("Variant", invitation.getVariant()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.aX()) {
            com.google.android.gms.games.multiplayer.a.a(this, dest, flags);
        } else {
            this.nL.writeToParcel(dest, flags);
            dest.writeString(this.nM);
            dest.writeLong(this.nN);
            dest.writeInt(this.nO);
            this.nP.writeToParcel(dest, flags);
            int n2 = this.nQ.size();
            dest.writeInt(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.nQ.get(i2).writeToParcel(dest, flags);
            }
        }
    }

    static final class a
    extends com.google.android.gms.games.multiplayer.a {
        a() {
        }

        public InvitationEntity v(Parcel parcel) {
            int n2;
            boolean bl2 = InvitationEntity.c(InvitationEntity.aW());
            if (bl2 || InvitationEntity.y(InvitationEntity.class.getCanonicalName())) {
                return super.v(parcel);
            }
            GameEntity gameEntity = (GameEntity)GameEntity.CREATOR.createFromParcel(parcel);
            String string2 = parcel.readString();
            long l2 = parcel.readLong();
            int n3 = parcel.readInt();
            ParticipantEntity participantEntity = (ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel);
            int n4 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n4);
            for (n2 = 0; n2 < n4; ++n2) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            n2 = -1;
            return new InvitationEntity(1, gameEntity, string2, l2, n3, participantEntity, arrayList, n2);
        }

        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.v(x0);
        }
    }
}

